## Team stakeholders

<!-- Determine team members who will help define scope, provide data, participate in research, or join workshops during the mapping process. -->

| Counterpart         | Username            | Role                |
|---------------------|---------------------|---------------------|
| Product Management  |                     |                     |
| Product Design      |                     |                     |
| Research            |                     |                     |
| Engineering         |                     |                     |
| Marketing           |                     |                     |
| Customer support    |                     |                     |

## Journey fundamentals

<!-- Identify the Job to be Done (JTBD) in this user journey before mapping. This ensures you map the right journey by understanding what users fundamentally want to accomplish, rather than documenting inefficient workflows that don't serve user needs. -->

- **Job performer:** _Whose experience will you be evaluating?_
- **Job to be done:** _What is their main job?_
- **Scenario:** _What is that user trying to accomplish?_
- **Customer segment** _What attributes are important for this job performer to have? Remove unnecessary segments._
  - **Relationship stage:** _Net new customers vs. users joining established groups_
  - **Monetization status:** _Paid vs. free users_
  - **Industry context:** _Industry/vertical-specific workflows and needs_
  - **Organization size:** _Company size considerations (SMB vs. mid-market vs. enterprise)_
  - **User role:** _Role-based experiences (GitLab administrators vs. end users)_
  - **User type**: _Power users vs. basic users (survey data showed these groups have opposing responses to the same features)_

## Research questions

<!-- Determine what questions are most important to answer with the creation of this user journey. Use the questions below as a starting point, adding and/or removing questions as applicable. -->

1. **Process Efficiency**
    * Where do users experience the most friction in their current workflows?
    * Which stages require the most transitions or context switching?
    * What tasks take disproportionate time relative to their value?
2. **Repetitive Steps**
    * What tasks are repetitive and time-consuming but necessary?
    * Which activities follow predictable patterns that could be streamlined?
    * What work gets duplicated across stages?
3. **Information Access**
    * What information do users need but struggle to find?
    * What knowledge are users missing?
    * When do users leave the platform to get information elsewhere?
4. **Handoffs & Transitions**
    * Where do workflows break down between stages or people?
    * What context gets lost during transitions?
    * How do different users coordinate within the process?
5. **Improvement Opportunities**
    * Where could automation provide the greatest value?
    * What guidance or support would reduce user effort?
    * Which tasks could be simplified or eliminated entirely?

## Data collection

<!-- Gather existing user behavior data, support feedback, research findings, and team insights before starting your journey mapping. -->

* ...
* ...
* ...

## Research

<!-- Determine if new research needs to be conducted. Select the best approach to gather needed data from the various [Research Methods](https://handbook.gitlab.com/handbook/product/ux/user-journeys/#research-methodologies) available. -->

* ...
* ...
* ...

## Journey Mapping

<!-- Based on the job to be done and the questions you want to answer, use the [handbook guidance](https://handbook.gitlab.com/handbook/product/ux/user-journeys/#journey-map-elevations) to determine which map elevation level supports your goals. -->

<!-- Using the provided [journey map template](https://www.figma.com/board/CAw05ogtEWiRrhW48Uqt22/Journey-Mapping-Templates?t=1JJ6j6cP2HnekP6w-6), create your own journey map Figjam file within the [Journey Maps Figma team](https://www.figma.com/files/972612628770206748/team/1517620701713485782). -->

* **Journey map elevation level:** _Macro, mid, or micro_
* **Journey map link:** [User journey map Figjam](ADD LINK)

* [ ] Complete your journey map using the [best practices](https://handbook.gitlab.com/handbook/product/ux/user-journeys/#best-practices)

## Action planning

After finishing your journey map, complete the following:

* [ ] Create an [actionable insight issue](https://gitlab.com/gitlab-org/gitlab/-/issues/new?description_template=Actionable%20Insight%20-%20Product%20change) for each opportunity identified. Mark them related to this issue.
* [ ] Share a link to this issue and your journey map in our [#GitLab-user-journeys (internal)](https://gitlab.enterprise.slack.com/archives/C0927BQATJA) slack channel.

/label ~"user journey"
/label ~"user journey elevation::" <!-- Add elevation label -->
/label ~"FY26::" <!-- Add relevant fiscal year and quarter -->
/label ~"golden journey" <!-- Remove label if journey is not a [golden journey](https://handbook.gitlab.com/handbook/product/ux/user-journeys/#key-terminology) -->
/confidential
